# Mods (v6)

SmallMart supports two mod formats.

## 1) Legacy single-file mods
Place a PHP file in:
- `mods/your_mod.php`

Optional init functions (first one found is called):
- `your_mod_init()`
- `init()`
- `your_mod_initialize()`

Metadata can be provided via a docblock in the file (existing v6.1.5 behavior).

## 2) Package mods (NEW in v6)
Create a folder:
- `mods/<your-mod-id>/`

Required:
- `mods/<your-mod-id>/manifest.json`

Example `manifest.json`:
```json
{
  "id": "hello-world",
  "name": "Hello World",
  "version": "1.0.0",
  "description": "Adds a banner to the homepage",
  "author": "You",
  "entry": "main.php",
  "enabled_by_default": true
}
```

Entry file:
- `mods/<your-mod-id>/main.php`

Optional init function naming:
- `<id>_init()` or `init()`

### Hooks API
Use:
- `SmallMartModAPI::addHook($hookName, $callback, $priority)`
or the alias:
- `SmallMartModAPI::registerHook(...)`

Example:
```php
SmallMartModAPI::addHook('footer_after', function () {
    echo '<div class="muted">Injected by a mod.</div>';
});
```

